var express = require("express");
const router = express.Router();
const db = require("../../utils/database");

router.get("/selectFeedback", (req, res) => {
  //const factor = req.body.factor;
  let query = `SELECT * from finehhdi_CL.FeedbackCL ORDER BY id DESC`;
  // console.log(query);
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log(err);
        // console.log("error");
      } else {
        res.status(200).send({
          message: "Data Selected Successfully",
          data: data,
        });
      }
    });
  });
});

router.get("/selectFeedbackLimitedData", (req, res) => {
  //const factor = req.body.factor;
  let query = `SELECT * from finehhdi_CL.FeedbackCL ORDER BY id DESC LIMIT 500`;
  // console.log(query);
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log(err);
        // console.log("error");
      } else {
        res.status(200).send({
          message: "Data Selected Successfully",
          data: data,
        });
      }
    });
  });
});

//select area api
router.get("/selectArea", (req, res) => {
  const areaName = req.body.areaName;
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    let query = `select * from finehhdi_eDefect.Department`;
    // console.log("quey from show area data", query);
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("errrrrorrrrr", err);

        res.status(401).json({
          message: "Some error in select CL selection",
          results: "Failed",
          data: [],
        });
      } else {
        res.status(201).json({
          message: "select data Successfully",
          results: "Success",
          data: data,
        });
        // console.log("dataaaaaa", data);
      }
    });
  });
});

//select Machine api
router.get("/selectMachineName", (req, res) => {
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    let query = `select * from finehhdi_eDefect.machineTypes`;
    // console.log("quey from show area data", query);
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("errrrrorrrrr", err);

        res.status(401).json({
          message: "Some error in select CL selection",
          results: "Failed",
          data: [],
        });
      } else {
        res.status(201).json({
          message: "select data Successfully",
          results: "Success",
          data: data,
        });
        // console.log("dataaaaaa", data);
      }
    });
  });
});

// new changes start 4-jan-2023
router.post("/selectMachine", (req, res) => {
  const areaName = req.body.areaName;
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    let query = `select * from finehhdi_eDefect.machineTypes where department="${areaName}" `;

    // console.log("query from select machine===>", query);
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log(err);
        console.log("error");
      } else {
        res.status(200).send({
          message: "Data Selected Successfully",
          data: data,
        });
      }
    });
  });
});
// new changes end 4-jan-2023

router.post("/withMachineAndArea", (req, res) => {
  const areaName = req.body.areaName;
  const machineName = req.body.machineName;
  const startDate = req.body.startDate;
  const endDate = req.body.endDate;
  // let query = `select * from finehhdi_CL.FeedbackCL where areaName="${areaName}" And machineName="${machineName}" `;
  // let query = `select * from finehhdi_CL.FeedbackCL where areaName="${areaName}" AND machineName="${machineName}" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%Y-%m-%d') >= "${startDate}" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%Y-%m-%d') <= "${endDate}" `;
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    let query = `
    select * from finehhdi_CL.FeedbackCL where areaName="${areaName}" AND machineName="${machineName}" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%Y-%m-%d') >= "${startDate}" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%Y-%m-%d') <= "${endDate}" 
    `;
    // select * from FeedbackCL where areaName="B1" AND machineName="Bretting1-Area1" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%d-%m-%Y') >= "${01-12-2021}" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%d-%m-%Y') <= "${30-12-2021}"

    // console.log(
    //   "query from select feedback from machine and areaName ===>",
    //   query
    // );
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log(err);
        console.log("error");
      } else {
        res.status(200).send({
          message: "Data Selected Successfully",
          data: data,
        });
      }
    });
  });
});

router.get("/selectOwnerName", (req, res) => {
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    let query = `select equipmentOwnerName from finehhdi_CL.ConfigCL`;
    // console.log("query from select ownerName===>", query);
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log(err);
        // console.log("error");
      } else {
        res.status(200).send({
          message: "Data Selected Successfully",
          data: data,
        });
      }
    });
  });
});

// For FIlter Data

router.post("/getFilterData", (req, res) => {
  const startDate = req.body.startDate;
  const endDate = req.body.endDate;
  console.log("start dat and endDate", startDate, endDate);
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    connection.query(
      `SELECT * FROM finehhdi_CL.FeedbackCL WHERE DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%Y-%m-%d') >= "${startDate}" AND DATE_FORMAT(STR_TO_DATE(dateAndTime,'%d-%m-%Y'), '%Y-%m-%d') <= "${endDate}"`,
      (err, data) => {
        connection.release();
        if (err) {
          res.status(500).send({
            msg: "err getting result",
            filter: [],
          });
        } else {
          res.status(200).send({
            msg: "success",
            filter: data,
          });
        }
      }
    );
  });
});

//get filter feedback
router.post("/getFilterDataAcknowledge", (req, res) => {
  const startDate = req.body.startDate;
  const endDate = req.body.endDate;
  // console.log("start dat and endDate", startDate, endDate);
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      res.send(500).status({
        msg: "Error from database",
        err: err,
      });
    }
    connection.query(
      `SELECT * FROM finehhdi_CL.Acknowledgement WHERE DATE_FORMAT(STR_TO_DATE(creationDateTime,'%d/%m/%Y'), '%Y-%m-%d') >= "${startDate}" AND DATE_FORMAT(STR_TO_DATE(creationDateTime,'%d/%m/%Y'), '%Y-%m-%d') <= "${endDate}"`,
      (err, data) => {
        connection.release();
        if (err) {
          console.log(err);
          res.status(500).send({
            msg: "err getting result",
            filter: [],
          });
        } else {
          res.status(200).send({
            msg: "success",
            filter: data,
          });
        }
      }
    );
  });
});

module.exports = router;
