const express = require("express");
const cors = require("cors");
const app = express();
const db = require("./utils/database");
const userAuth = require("./middleware/userAuth");
const rateLimit = require('express-rate-limit');
const xss = require('xss-clean');
const helmet = require('helmet');

const limiter = rateLimit({
	windowMs: 15 * 60 * 1000, // 15 minutes
	limit: 100, // Limit each IP to 100 requests per `window` (here, per 15 minutes).
	standardHeaders: 'draft-7', // draft-6: `RateLimit-*` headers; draft-7: combined `RateLimit` header
	legacyHeaders: false, // Disable the `X-RateLimit-*` headers.
	// store: ... , // Use an external store for consistency across multiple server instances.
  message: "you have exceed the number of request"
});

//
//MiddleWares
app.use(cors());
app.use(express.urlencoded({ extended: true }));
app.use(express.json());
app.use(express.static("public"));


app.use(helmet());

// Apply the rate limiting middleware to all requests.
app.use(limiter);

// make sure this comes before any routes
app.use(xss());

//Routes Varaibles

// for SetCentralLine
const createCL = require("./Apis/ConfigCL/createCL");
const selectCL = require("./Apis/ConfigCL/selectCL");
const updateCL = require("./Apis/ConfigCL/updateCL");
const deleteCL = require("./Apis/ConfigCL/deleteCL");
//for CL filter
// const filterCL = require("./Apis/ConfigCL/FilterCL")

//for Feedback
const createfb = require("./Apis/FeedBack/Create");
const selectfb = require("./Apis/FeedBack/Select");

//for Acknowledgement
const createAcknowledge = require("./Apis/Acknowledge/Create");
const updateAcknowledge = require("./Apis/Acknowledge/Update");
const selectAcknowledge = require("./Apis/Acknowledge/Select");

//for UserEmail
const updateUserEmail = require("./Apis/UserEmail/Update");
const createUserEmail = require("./Apis/UserEmail/Create");
const selectUserEmail = require("./Apis/UserEmail/Select");
const deleteUserEmail = require("./Apis/UserEmail/Delete");

//for Product
const updateProduct = require("./Apis/Product/Update");
const createProduct = require("./Apis/Product/Create");
const selectProduct = require("./Apis/Product/Select");
const deleteProduct = require("./Apis/Product/Delete");

//for user data using in user Email component
const selectUsers = require("./Apis/UserEmail/Select");

// for select machine
const selectMachine = require("./Apis/FeedBack/Select");

//for ownerName
const selectOwner = require("./Apis/FeedBack/Select");

//for area name
const selectareaName = require("./Apis/FeedBack/Select");

//for select CLData according to the machine
// const selectCLData = require("./Apis/ConfigCL/selectCL")

//Routes
//for SetCentralLine
app.use("/api/SetCentralLine", userAuth, createCL);
app.use("/api/SetCentralLine", userAuth, selectCL);
app.use("/api/SetCentralLine", userAuth, updateCL);
app.use("/api/SetCentralLine", userAuth, deleteCL);
//for CL filter
// app.use("/api/defectFilter", userAuth,filterCL)

//for feedback
app.use("/api/Feedback", userAuth, createfb);
app.use("/api/Feedback", userAuth, selectfb);

//for Acknowledgement

app.use("/api/Acknowledge", userAuth, createAcknowledge);
app.use("/api/Acknowledge", userAuth, selectAcknowledge);
app.use("/api/Acknowledge", userAuth, updateAcknowledge);

//for userEmail
app.use("/api/userEmail", userAuth, selectUserEmail);
app.use("/api/userEmail", userAuth, createUserEmail);
app.use("/api/userEmail", userAuth, updateUserEmail);
app.use("/api/userEmail", userAuth, deleteUserEmail);
//for product
app.use("/api/product", userAuth, selectProduct);
app.use("/api/product", userAuth, createProduct);
app.use("/api/product", userAuth, updateProduct);
app.use("/api/product", userAuth, deleteProduct);

//for select owmer Name
app.use("/api/ownerName", userAuth, selectOwner);

// for select machine name
app.use("/api/machineName", userAuth, selectMachine);

//for area Name
app.use("/api/areaName", userAuth, selectareaName);

//for user data
app.use("/api/userData", userAuth, selectUsers);

//for select CL data according to machine and shift
//  app.use("/api/CLdata", userAuth,selectCLData)

//Test Api
app.get("/get", userAuth, (req, res) => {
  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected >>>", err);
    }
  });
  console.log("get connection >>>");
  res.send("CODE: REFLUX");
  console.log("release connection >>>");
});

const port = 5000;

//Server Listining
app.listen(port, "0.0.0.0", () => {
  console.log(`Example app listening at http://localhost:${port}`);
});
